/**
 * Code generated by ISC
 * ISC Version: v1.0.0
 * Do not edit this file manually!
 * This code will be regenerated on every change
 */
// Import param handler module
const api = require('@lightware/isc-instance-api');
let params = null;
let instanceApi = null;

if (api.params && api.instanceApi) {
  params = api.params;
  instanceApi = api.instanceApi;
} else {
  params = require('@lightware/isc-params-api');
  instanceApi = api;
}

class TCC_M_driver {
  constructor() {
    this.instance = instanceApi.getInstance();

    /* Registering events */
    this.instance.registerEvent('intMicGain', async () => {}, async () => {});
    this.instance.registerEvent('speakerLevel', async () => {}, async () => {});
    this.instance.registerEvent('micIdentity', async () => {}, async () => {});
    this.instance.registerEvent('muteState', async () => {}, async () => {});
    this.instance.registerEvent('ledState', async () => {}, async () => {});
    this.instance.registerEvent('error', async () => {}, async () => {});
    this.instance.registerEvent('responseReceived', async () => {}, async () => {});

    /* Registering events end */

    /* Registering methods */
    this.instance.registerMethod('internalMicGain', this.internalMicGain.bind(this));
    this.instance.registerMethod('setLedBrightness', this.setLedBrightness.bind(this));
    this.instance.registerMethod('speakerVolume', this.speakerVolume.bind(this));
    this.instance.registerMethod('internalMicMute', this.internalMicMute.bind(this));
    this.instance.registerMethod('internalMicUnMute', this.internalMicUnMute.bind(this));
    this.instance.registerMethod('ident', this.ident.bind(this));
    this.instance.registerMethod('put', this.put.bind(this));
    this.instance.registerMethod('post', this.post.bind(this));
    this.instance.registerMethod('get', this.get.bind(this));
    this.instance.registerMethod('del', this.del.bind(this));

    /* Registering methods end */

    this.init();

    /* Rules */
    // Set actions for rules



    /* Rules end */
  }

  async init() {
    /* Custom user code */
    const rest = require("@lightware/rest-client");
    //Status board colorcodes
    this.colorCodes = {
      warning: "#f90",
      error: "#e74747",
      success: "#08d15d",
    };

    //Init statuses
    this.instance.updateStatus("Last Request Timestamp", "Undefined", {
      color: this.colorCodes["warning"],
    });
    this.instance.updateStatus("Last Request Status", "Undefined", {
      color: this.colorCodes["warning"],
    });

    //Init event handlers
    this.instance.on("error", (e) => {
      console.error(e);
    });

    this.instance.on('responseReceived', response => {
      try {
        //Answer can be a parsed JS object, binary buffer or string, check if we need to convert it
        if (typeof response !== "string") {
          response = JSON.stringify(response);
        }
        if (Buffer.isBuffer(response)) {
          //If it's a buffer, with a JSON.stringify we will "flatten" it to a JSON string -> after a JSON.parse, the data property will contain the raw array -> it is converted back to a string by toString()
          response = JSON.parse(JSON.stringify(response))["data"].flat().toString();
        }
        this.instance.variables['lastResponse'].value = response;
      } catch (e) {
        console.error(e);
        this.instance.variables['lastResponse'].value = null;
      }
    });

    const parsedParams = {
      ipAddressOrHost: params.ipAddressOrHost,
      protocol: "https",
      portNumber: 443,
      authenticationType: "Basic",
      username: "api",
      password: params.password,
      customHeaders: [],
      certAuthEnable: false,
    };

    if (typeof(parsedParams.customHeaders) != "object") {
      parsedParams.customHeaders = [];
    }

    //customHeaders is an array of header key value pairs as strings as elements (list param) as headerType:headerContent strings-> we have to fetch if it contains any Content-Type header
    if (typeof(parsedParams.customHeaders) != "undefined" && parsedParams.customHeaders != null) {
      var hasContentTypeHeader = false;
      if (parsedParams.customHeaders.length == 0) {
        hasContentTypeHeader = false;
      } else {
        parsedParams.customHeaders.forEach((element) => {
          let [headerType, headerContent] = element.split(":");
          if (/content-type/ig.test(headerType)) hasContentTypeHeader = true;
        }, this);
      }
      //If the array is empty OR there were no content-type header defined, then set it to JSON
      if (!hasContentTypeHeader) parsedParams.customHeaders.push("Content-Type:application/json");
    }

    this.restClientInstance = new rest.RestClient(
      parsedParams.ipAddressOrHost,
      parsedParams.protocol,
      parsedParams.portNumber,
      parsedParams.authenticationType,
      parsedParams.username,
      parsedParams.password,
      parsedParams.customHeaders,
      parsedParams.certAuthEnable,
      //logEnable
      false
    );

    /* Events */
    this.subscribeToResponseReceivedIncludes = (eventName, includesString) => {
      this.instance.on('responseReceived', response => {
        //Answer can be a parsed JS object, binary buffer or string, check if we need to convert it
        if (typeof response !== "string") {
          response = JSON.stringify(response);
        }
        if (Buffer.isBuffer(response)) {
          //If it's a buffer, with a JSON.stringify we will "flatten" it to a JSON string -> after a JSON.parse, the data property will contain the raw array -> it is converted back to a string by toString()
          response = JSON.parse(JSON.stringify(response))["data"].flat().toString();
        }
        if (response.includes(includesString)) {
          this.instance.dispatchEvent(eventName, response);
        }
      });
    };

    this.subscribeToResponseReceivedMatches = (eventName, regexString) => {
      const regex = new RegExp(regexString);
      this.instance.on('responseReceived', response => {
        //Answer can be a parsed JS object, binary buffer or string, check if we need to convert it
        if (typeof response !== "string") {
          response = JSON.stringify(response);
        }
        if (Buffer.isBuffer(response)) {
          //If it's a buffer, with a JSON.stringify we will "flatten" it to a JSON string -> after a JSON.parse, the data property will contain the raw array -> it is converted back to a string by toString()
          response = JSON.parse(JSON.stringify(response))["data"].flat().toString();
        }
        if (regex.test(response)) {
          this.instance.dispatchEvent(eventName, response);
        }
      });
    };

    /* Events end */

    /* Custom code start */

    let identity = await instanceApi.getSelf().get('/api/device/identity');

    if (identity.product != undefined) {
      this.instance.updateStatus("Product", identity.product, {
        color: this.colorCodes["success"],
      });
      this.instance.updateStatus("HardwareRevision", identity.hardwareRevision, {
        color: this.colorCodes["success"],
      });
      this.instance.updateStatus("Serial", identity.serial, {
        color: this.colorCodes["success"],
      });
      this.instance.updateStatus("Vendor", identity.vendor, {
        color: this.colorCodes["success"],
      });
    } else {
      this.instance.updateStatus("Product", "N/A", {
        color: this.colorCodes["error"],
      });
      this.instance.updateStatus("HardwareRevision", "N/A", {
        color: this.colorCodes["error"],
      });
      this.instance.updateStatus("Serial", "N/A", {
        color: this.colorCodes["error"],
      });
      this.instance.updateStatus("Vendor", "N/A", {
        color: this.colorCodes["error"],
      });
    };

    // mute status start
    let muteState = await instanceApi.getSelf().get(`/api/audio/inputs/internalMic/mute`);
    if (muteState.enabled != undefined) {
      this.instance.updateStatus("Internal Mic Mute", muteState.enabled, {
        color: this.colorCodes["success"]
      });
    } else {
      this.instance.updateStatus("Mute", "N/A", {
        color: this.colorCodes["error"]
      });
    }
    // mute status end


    /* Custom code end */
    /* Custom user code end */
  }

  /* Methods */
  /**
   * @method internalMicGain
   * @param {number} gain
   * @returns {void}
   * @description {Set%20internal%20mic%20gain%20%20%5B%20-60%20dB%20..%20%200%20dB%20%5D}
   */
  async internalMicGain(gain) {
    await instanceApi.getSelf().put(`/api/audio/inputs/internalMic`, `{ \"gain\": ` + gain + `}`, `[]`);

    let microphoneGain = await instanceApi.getSelf().get(`/api/audio/inputs/internalMic`);
    this.instance.dispatchEvent('intMicGain', microphoneGain.gain);
  }
  /**
   * @method setLedBrightness
   * @param {number} brightness
   * @returns {void}
   * @description {Set%20LED%20brightness%20%20%5B%200..5%20%5D}
   */
  async setLedBrightness(brightness) {
    await instanceApi.getSelf().put(`/api/device/leds/ring`, `{"brightness":  ${brightness}   }`, `[]`);

    let ledState = await instanceApi.getSelf().get(`/api/device/leds/ring`);
    this.instance.dispatchEvent('ledState', ledState.brightness);
  }
  /**
   * @method speakerVolume
   * @param {number} volume
   * @returns {void}
   * @description {set%20Speaker's%20volume%20%5B%200..100%20%5D%20}
   */
  async speakerVolume(volume) {
    let commandString = {
      "volume": volume
    };
    await instanceApi.getSelf().put(`/api/audio/outputs/speaker`, JSON.stringify(commandString), '{}');

    let speakerVolume = await instanceApi.getSelf().get(`/api/audio/outputs/speaker`);
    this.instance.dispatchEvent('speakerLevel', speakerVolume.volume);
  }
  /**
    * @method internalMicMute

    * @returns {void}
    * @description {Sends%20Mute%20command%20to%20mic}
  */
  async internalMicMute() {
    await instanceApi.getSelf().put(`/api/audio/inputs/internalMic/mute`, '{\"enabled\": true}', '[]');

    let muteState = await instanceApi.getSelf().get(`/api/audio/inputs/internalMic/mute`);

    if (muteState.enabled != undefined) {
      this.instance.updateStatus("Internal Mic Mute", muteState.enabled, {
        color: this.colorCodes["success"]
      });
    } else {
      this.instance.updateStatus("Internal Mic Mute", "N/A", {
        color: this.colorCodes["error"]
      });
    }

    this.instance.dispatchEvent('muteState', muteState.enabled);
  }
  /**
    * @method internalMicUnMute

    * @returns {void}
    * @description {Sends%20unmute%20command%20to%20mic}
  */
  async internalMicUnMute() {
    await instanceApi.getSelf().put(`/api/audio/inputs/internalMic/mute`, `{ \"enabled\": false}`, `[]`);
    let muteState = await instanceApi.getSelf().get(`/api/audio/inputs/internalMic/mute`);

    if (muteState.enabled != undefined) {
      this.instance.updateStatus("Internal Mic Mute", muteState.enabled, {
        color: this.colorCodes["success"]
      });
    } else {
      this.instance.updateStatus("Internal Mic Mute", "N/A", {
        color: this.colorCodes["error"]
      });
    }

    this.instance.dispatchEvent('muteState', muteState.enabled);
  }
  /**
    * @method ident

    * @returns {void}
    * @description {MIC%20identification}
  */
  async ident() {
    let identity = await instanceApi.getSelf().get('/api/device/identity');
    if (params.logEnabled) console.log("Mic identity : ", identity);

    this.instance.dispatchEvent('micIdentity', identity);
  }
  /**
   * @method put
   * @param {string} path
   * @param {json} parameters
   * @param {json} customHeaders
   * @returns {any}
   * @description {}
   */
  async put(path, parameters, customHeaders) {
    this.instance.updateStatus("Last Request Timestamp", new Date(), {
      color: this.colorCodes["success"],
    });
    return this.restClientInstance
      .put(path, parameters, customHeaders, "PUT")
      .then((res) => {
        this.instance.updateStatus("Last Request Status", "OK", {
          color: this.colorCodes["success"],
        });
        //Trigger a received event, upon response
        this.instance.dispatchEvent("responseReceived", res);
        return res;
      })
      .catch((e) => {
        this.instance.dispatchEvent("error", e.message);
        this.instance.updateStatus("Last Request Status", "Error", {
          color: this.colorCodes["error"],
        });
        return e;
      });
  }
  /**
   * @method post
   * @param {string} path
   * @param {json} parameters
   * @param {json} customHeaders
   * @returns {any}
   * @description {}
   */
  async post(path, parameters, customHeaders) {
    this.instance.updateStatus("Last Request Timestamp", new Date(), {
      color: this.colorCodes["success"],
    });
    return this.restClientInstance
      .post(path, parameters, customHeaders, "POST")
      .then((res) => {
        this.instance.updateStatus("Last Request Status", "OK", {
          color: this.colorCodes["success"],
        });
        //Trigger a received event, upon response
        this.instance.dispatchEvent("responseReceived", res);
        return res;
      })
      .catch((e) => {
        this.instance.dispatchEvent("error", e.message);
        this.instance.updateStatus("Last Request Status", "Error", {
          color: this.colorCodes["error"],
        });
        return e;
      });
  }
  /**
   * @method get
   * @param {string} path
   * @param {json} parameters
   * @param {json} customHeaders
   * @returns {any}
   * @description {}
   */
  async get(path, parameters, customHeaders) {
    this.instance.updateStatus("Last Request Timestamp", new Date(), {
      color: this.colorCodes["success"],
    });
    return this.restClientInstance
      .get(path, parameters, customHeaders, "GET")
      .then((res) => {
        this.instance.updateStatus("Last Request Status", "OK", {
          color: this.colorCodes["success"],
        });
        //Trigger a received event, upon response
        this.instance.dispatchEvent("responseReceived", res);
        return res;
      })
      .catch((e) => {
        this.instance.dispatchEvent("error", e.message);
        this.instance.updateStatus("Last Request Status", "Error", {
          color: this.colorCodes["error"],
        });
        return e;
      });
  }
  /**
   * @method del
   * @param {string} path
   * @param {json} parameters
   * @param {json} customHeaders
   * @returns {any}
   * @description {}
   */
  async del(path, parameters, customHeaders) {
    this.instance.updateStatus("Last Request Timestamp", new Date(), {
      color: this.colorCodes["success"],
    });
    return this.restClientInstance
      .delete(path, parameters, customHeaders, "DELETE")
      .then((res) => {
        this.instance.updateStatus("Last Request Status", "OK", {
          color: this.colorCodes["success"],
        });
        //Trigger a received event, upon response
        this.instance.dispatchEvent("responseReceived", res);
        return res;
      })
      .catch((e) => {
        this.instance.dispatchEvent("error", e.message);
        this.instance.updateStatus("Last Request Status", "Error", {
          color: this.colorCodes["error"],
        });
        return e;
      });
  }

  /* Methods end */

}

const TCC_M_driverInstance = new TCC_M_driver();