import { ConditionInterface } from "./ConditionInterface";

export enum OperatorType {
  And = 'and',
  Or = 'or'
}

export class ConditionGroup implements ConditionInterface {
  private readonly conditions: ConditionInterface[] = [];

  constructor(private readonly operatorType: OperatorType) {

  }

  evaluate(...eventParameters: any[]): boolean {
    try {
      const conditions = this.conditions.map((condition) => condition.evaluate(...eventParameters));

      switch (this.operatorType) {
        case OperatorType.And: {
          if (conditions.length === 0) {
            return true;
          }
          return !conditions.includes(false);
        }
        case OperatorType.Or: {
          if (conditions.length === 0) {
            return true;
          }
          return conditions.includes(true);
        }
      }
    } catch (e: any) {
      console.error(e.message);
      return false;
    }
  }

  addCondition(condition: ConditionInterface): ConditionGroup {
    this.conditions.push(condition);
    return this;
  }
}
