const rateLimit = require('function-rate-limit');

class HijackConsole {
  constructor(limit, interval) {
    this.limit = limit;
    this.interval = interval;

    this.#hijackDebug();
    this.#hijackInfo();
    this.#hijackLog();
    this.#hijackWarn();
    this.#hijackError();
  }

  #hijackLog() {
    const originalFunc = console.log;
    console.log = rateLimit(this.limit, this.interval, async (...message) => {
      originalFunc(...message);
    });
  }

  #hijackError() {
    const originalFunc = console.error;
    console.error = rateLimit(this.limit, this.interval, async (...message) => {
      originalFunc(...message);
    });
  }

  #hijackWarn() {
    const originalFunc = console.warn;
    console.warn = rateLimit(this.limit, this.interval, async (...message) => {
      originalFunc(...message);
    });
  }

  #hijackDebug() {
    const originalFunc = console.debug;
    console.debug = rateLimit(this.limit, this.interval, async (...message) => {
      originalFunc(...message);
    });
  }

  #hijackInfo() {
    const originalFunc = console.info;
    console.info = rateLimit(this.limit, this.interval, async (...message) => {
      originalFunc(...message);
    });
  }
}

exports.HijackConsole = HijackConsole;