const common = require('./src/common');
const { CommAdaptor } = require('./src/CommAdaptor');
const { InstanceHandler } = require('./src/InstanceHandler');
const { InstanceInterface } = require('./src/InstanceInterface');
const { HijackConsole } = require('./HijackConsole');
const { RuleManager } = require('@lightware/triggers-api');
const params = require('@lightware/isc-params-api');

class InstanceAPI {
  instance = null;
  instanceInterfaces = {};
  params = params

  constructor() {
    this.instanceDir = process.argv[2];
    this.instanceId = this.instanceDir.substr(this.instanceDir.lastIndexOf('/') + 1);
    this.comm = new CommAdaptor();

    new HijackConsole(50, 1000);

    this.ruleManager = new RuleManager(this);
  }

  getInstance() {
    if (this.instance == null) {
      const moduleDescriptor = common.getModuleData(this.instanceDir);
      const packageData = common.getModulePackageData(this.instanceDir);

      this.instance = new InstanceHandler({
        instanceId: this.instanceId,
        instanceDir: this.instanceDir,
        comm: this.comm,
        moduleDescriptor,
        packageData
      });
    }

    return this.instance;
  }

  getSelf() {
    return this.getInstance();
  }

  getInstanceById(instanceId) {
    // If the instanceId parameter is empty string, that means the current instance
    if (!instanceId || instanceId == '') {
      return this.getInstance();
    }
    //Checking if we are in the same instance that we want to acquire
    if (instanceId == this.instanceId) {
      return this.getInstance();
    } else {
      if (typeof this.instanceInterfaces[instanceId] == 'undefined') {
        const instanceDirRoot = this.instanceDir.substr(0, this.instanceDir.lastIndexOf('/') + 1);
        const remoteInstanceDir = instanceDirRoot + instanceId;
        const moduleDescriptor = common.getModuleData(remoteInstanceDir);

        this.instanceInterfaces[instanceId] = new InstanceInterface({
          parent: this,
          instanceId: instanceId,
          comm: this.comm,
          moduleDescriptor: moduleDescriptor
        });
      }

      return this.instanceInterfaces[instanceId];
    }
  }

  getModuleData(instanceDir) {
    return common.getModuleData(instanceDir);
  }
}

module.exports = { instanceApi: new InstanceAPI(), params };
