/**
 * Common communication adaptor
 * Based on isDesktop variable value,
 * - creates a websocket client instance on frontend side
 * - uses the parentPort object on backend side
 */
class CommAdaptor {
  constructor(system) {
    this.messagePort = require('worker_threads').parentPort;
  }

  send(message) {
    this.messagePort.postMessage(message);
  }

  on(event, callback) {
    switch (event) {
      case 'message':
        this.messagePort.on('message', callback);
        break;
    }
  }
}

exports.CommAdaptor = CommAdaptor;
