import { ActionsDescriptor } from "./ActionsDescriptor";
import { ConditionDescriptor, ConditionGroupDescriptor } from "./ConditionDescriptor";
import { TriggerDescriptor } from "./TriggerDescriptor";
export declare class RuleDescriptor {
    readonly name: string;
    readonly enabled: boolean;
    readonly actions: ActionsDescriptor;
    readonly feId: string;
    readonly triggers: TriggerDescriptor[];
    readonly condition?: ConditionGroupDescriptor | ConditionDescriptor | undefined;
    readonly factory: boolean;
    readonly orderId: number;
    constructor(name: string, enabled: boolean, actions: ActionsDescriptor, feId: string, triggers: TriggerDescriptor[], condition?: ConditionGroupDescriptor | ConditionDescriptor | undefined, factory?: boolean, orderId?: number);
}
export type LegacyRuleDescriptor = {
    name: string;
    enabled?: boolean;
    actions: ActionsDescriptor;
    feId: string;
    event?: {
        instanceId: string;
        event: string;
    };
    triggers?: TriggerDescriptor[];
    condition?: ConditionGroupDescriptor | ConditionDescriptor;
    factory: boolean;
    orderId: number;
};
