import { ValueType } from "./ModuleDescriptorObject";

export type ConditionGroupDescriptor = {
  type: 'conditionGroup',
  operator: ConditionGroupOperator,
  conditions: Array<ConditionGroupDescriptor | ConditionDescriptor>
}

export enum ConditionGroupOperator {
  OR = 'or',
  AND = 'and'
}

export type ConditionDescriptor = {
  type: 'condition',
  left: LeftOperandDescriptor,
  operator: Operator,
  right: RightOperandDescriptor,
  duration: number
}

export type LeftOperandDescriptor =
  EventParameterOperandDescriptor |
  VariableOperandDescriptor |
  InstanceParameterOperandDescriptor

export type RightOperandDescriptor =
  EventParameterOperandDescriptor |
  VariableOperandDescriptor |
  ConstOperandDescriptor |
  InstanceParameterOperandDescriptor

export type EventParameterOperandDescriptor = {
  type: OperandType.EventCallbackParameter,
  instanceId: string,
  name: string,
  event: string
}

export type InstanceParameterOperandDescriptor = {
  type: OperandType.InstanceParameter,
  name: string
}

export type VariableOperandDescriptor = {
  type: OperandType.StatusVariable,
  instanceId: string,
  name: string
}

export type ConstOperandDescriptor = {
  type: OperandType.Constant,
  value: ValueType,
}

export enum OperandType {
  EventCallbackParameter = 'eventCallbackParameter',
  StatusVariable = 'StatusVariable',
  Constant = 'Constant',
  InstanceParameter = 'InstanceParameter'
}

export enum Operator {
  Equals = 'equals',
  NotEquals = 'not_equals',
  Less = 'less',
  LessOrEqual = 'less_or_equal',
  Greater = 'greater',
  GreaterOrEqual = 'greater_or_equal',
  Contains = 'contains',
  Regexp = 'regexp',
  '==' = Equals,
  '!=' = NotEquals,
  '<' = Less,
  '<=' = LessOrEqual,
  '>' = Greater,
  '>=' = GreaterOrEqual,
  'contains' = Contains,
  'regexp' = Regexp
}
