import { ActionsDescriptor } from "./ActionsDescriptor";
import { ConditionDescriptor, ConditionGroupDescriptor } from "./ConditionDescriptor";
import { TriggerDescriptor } from "./TriggerDescriptor";

export class RuleDescriptor {
  constructor(
    readonly name: string,
    readonly enabled: boolean,
    readonly actions: ActionsDescriptor,
    readonly feId: string,
    readonly triggers: TriggerDescriptor[],
    readonly condition?: ConditionGroupDescriptor | ConditionDescriptor,
    readonly factory: boolean = true,
    readonly orderId: number = 0
  ) {}
}

export type LegacyRuleDescriptor = {
  name: string,
  enabled?: boolean,
  actions: ActionsDescriptor,
  feId: string,
  event?: {
    instanceId: string,
    event: string
  },
  triggers?: TriggerDescriptor[],
  condition?: ConditionGroupDescriptor | ConditionDescriptor,
  factory: boolean,
  orderId: number
};
