"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Trigger = exports.TriggerType = void 0;
const node_events_1 = require("node:events");
const common_1 = require("./common");
var TriggerType;
(function (TriggerType) {
    TriggerType["Event"] = "event";
    TriggerType["VariableChanged"] = "variableChanged";
    TriggerType["VariableChangedToValue"] = "variableChangedToValue";
    TriggerType["VariableChangedFromTo"] = "variableChangedFromTo";
    TriggerType["VariableChangedIntoRange"] = "variableChangedIntoRange";
    TriggerType["Time"] = "time";
})(TriggerType || (exports.TriggerType = TriggerType = {}));
class Trigger {
    constructor(type, durationMs) {
        this.type = type;
        this.durationMs = durationMs;
        this.durationTimeout = undefined;
        this.eventEmitter = new node_events_1.EventEmitter();
    }
    start(...triggerArgs) {
        if (this.durationMs === 0) {
            this.eventEmitter.emit(common_1.triggeredEventName, ...triggerArgs);
        }
        else if (this.durationTimeout == undefined) {
            this.durationTimeout = setTimeout(() => {
                this.eventEmitter.emit(common_1.triggeredEventName, ...triggerArgs);
            }, this.durationMs);
        }
    }
    reset() {
        clearTimeout(this.durationTimeout);
        this.durationTimeout = undefined;
    }
    onTriggered(listener) {
        this.eventEmitter.on(common_1.triggeredEventName, listener);
    }
}
exports.Trigger = Trigger;
//# sourceMappingURL=Trigger.js.map