"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseMessage = void 0;
const VariableAddedMessage_1 = require("./VariableAddedMessage");
const VariableChangedMessage_1 = require("./VariableChangedMessage");
const VariableGetRemoteMessage_1 = require("./VariableGetRemoteMessage");
const VariableGetRemoteResponse_1 = require("./VariableGetRemoteResponse");
const VariableMessageType_1 = require("./VariableMessageType");
const parseMessage = (jsonString) => {
    const jsonObject = JSON.parse(jsonString);
    switch (jsonObject.messageType) {
        case VariableMessageType_1.VariableMessageType.Changed:
            return Object.setPrototypeOf(jsonObject, VariableChangedMessage_1.VariableChangedMessage.prototype);
        case VariableMessageType_1.VariableMessageType.Added:
            return Object.setPrototypeOf(jsonObject, VariableAddedMessage_1.VariableAddedMessage.prototype);
        case VariableMessageType_1.VariableMessageType.GetRemote:
            return Object.setPrototypeOf(jsonObject, VariableGetRemoteMessage_1.VariableGetRemoteMessage.prototype);
        case VariableMessageType_1.VariableMessageType.GetRemoteResponse:
            return Object.setPrototypeOf(jsonObject, VariableGetRemoteResponse_1.VariableGetRemoteResponse.prototype);
    }
    return null;
};
exports.parseMessage = parseMessage;
//# sourceMappingURL=MessageParser.js.map