import { LocalVariable } from "../LocalVariable";
import { TypeSignature, VariableType } from "../Variable";

export class VariableStateMessageData {
  constructor(public readonly variableName: string,
              public readonly ownerId: string,
              public readonly typeSignature?: TypeSignature,
              public readonly currentValue?: VariableType,
              public readonly previousValue?: VariableType,
              public readonly lastModifiedMs?: number) {}

  static create(variable: LocalVariable): VariableStateMessageData {
    return new VariableStateMessageData(variable.name,
                                        variable.ownerId,
                                        variable.typeSignature,
                                        variable.value,
                                        variable.previousValue,
                                        variable.lastModifiedMs);
  }

  static createUndefined(variableName: string, ownerId: string): VariableStateMessageData{
    return new VariableStateMessageData(variableName, ownerId);
  }
}
