"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConditionGroup = exports.OperatorType = void 0;
var OperatorType;
(function (OperatorType) {
    OperatorType["And"] = "and";
    OperatorType["Or"] = "or";
})(OperatorType = exports.OperatorType || (exports.OperatorType = {}));
class ConditionGroup {
    constructor(operatorType) {
        this.operatorType = operatorType;
        this.conditions = [];
    }
    evaluate(...eventParameters) {
        try {
            const conditions = this.conditions.map((condition) => condition.evaluate(...eventParameters));
            switch (this.operatorType) {
                case OperatorType.And: {
                    if (conditions.length === 0) {
                        return true;
                    }
                    return !conditions.includes(false);
                }
                case OperatorType.Or: {
                    if (conditions.length === 0) {
                        return true;
                    }
                    return conditions.includes(true);
                }
            }
        }
        catch (e) {
            console.error(e.message);
            return false;
        }
    }
    addCondition(condition) {
        this.conditions.push(condition);
        return this;
    }
}
exports.ConditionGroup = ConditionGroup;
//# sourceMappingURL=ConditionGroup.js.map