import { EventDescriptor } from "./EventDescriptor";
import { MethodDescriptor } from "./MethodDescriptor";
import { ModuleDescriptorObject } from "./ModuleDescriptorObject";
import { RuleDescriptor, LegacyRuleDescriptor } from "./RuleDescriptor";
import { VariableDescriptor } from "./VariableDescriptor";
export declare class ModuleDescriptorData {
    methods: Array<MethodDescriptor>;
    events: Array<EventDescriptor>;
    rules: Array<RuleDescriptor>;
    variables: Array<VariableDescriptor>;
}
export declare class ModuleDescriptor extends ModuleDescriptorData {
    private methodsFromEntryCodeData;
    constructor();
    readDescriptor(descriptorPath: string, entryCodePath?: string): void;
    loadFromDescriptorObject(moduleDescriptorObject: ModuleDescriptorObject, moduleEntryCode?: string): void;
    loadFromModuleDescriptorData(moduleDescriptorData: ModuleDescriptorData): void;
    private loadMethods;
    private initMethod;
    private loadEvents;
    private initEvents;
    private loadVariables;
    private loadRules;
    /**
     * @brief Compares the interface of the modules. The User additions are ignored.
     *        Method signatures and event callback signatures are compared.
     *        The method and event codes are ignored.
     * @param other The other ModuleDescrirptor to compare with.
     * @returns true if the Moduledescriptors are compatible with each other.
     */
    isCompatibleWith(other: ModuleDescriptor): boolean;
    private compareMethodSignature;
    private compareParameters;
    /**
     * @brief   Gets the extension descriptor of the module, basically returns all the elements
     *          which factory property equals to false.
     * @returns ModuleDescriptorData with the user additive elments.
     */
    getExtensions(): ModuleDescriptorData;
    /**
     * @brief   Check if the rules in the module are in the old format (event instead of trigger)
     * @returns void
     */
    convertRules(rules: LegacyRuleDescriptor[]): LegacyRuleDescriptor[];
    saveDescriptor(path: string, moduleName: string, moduleId: string): Promise<void>;
    private seperateChildrenAndExtensions;
    private createModuleDescriptorObject;
}
