import { ActionsDescriptor } from "./ActionsDescriptor";
import { Parameter } from "./ModuleDescriptorObject";

export class EventDescriptor {
  constructor(
    readonly name: string,
    readonly callbackParameters: Parameter[],
    readonly actions: ActionsDescriptor,
    readonly description: string,
    readonly factory: boolean = true,
    readonly orderId: number = 0,
    readonly baseEventTemplateName?: string,
    readonly parameterValues?: Record<string, string>
  ) {}

  public getEventParameterIndex(parameterName: string): number {
    return this.callbackParameters.findIndex((p) => p.name === parameterName);
  }
}
