"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventTrigger = void 0;
const Trigger_1 = require("./Trigger");
class EventTrigger extends Trigger_1.Trigger {
    constructor(instanceId, eventName, instanceApi) {
        super(Trigger_1.TriggerType.Event, 0);
        this.instanceId = instanceId;
        this.eventName = eventName;
        this.instanceApi = instanceApi;
        if (typeof this.instanceApi.getInstanceById !== 'function') {
            throw new Error('InstanceApi is missing the getInstanceById function');
        }
        this.instanceApi.getInstanceById(this.instanceId).on(this.eventName, async (...args) => {
            this.start(...args);
        });
    }
}
exports.EventTrigger = EventTrigger;
//# sourceMappingURL=EventTrigger.js.map