export declare enum TriggerType {
    Event = "event",
    VariableChanged = "variableChanged",
    VariableChangedToValue = "variableChangedToValue",
    VariableChangedFromTo = "variableChangedFromTo",
    VariableChangedIntoRange = "variableChangedIntoRange",
    Time = "time"
}
export declare abstract class Trigger {
    private readonly type;
    private readonly durationMs;
    private durationTimeout;
    private readonly eventEmitter;
    constructor(type: TriggerType, durationMs: number);
    start(...triggerArgs: any[]): void;
    reset(): void;
    onTriggered(listener: (...triggerArgs: any[]) => void): void;
}
