import { EventTrigger } from "./EventTrigger";
jest.useFakeTimers();

describe('EventTrigger', () => {
  const mockInstanceApi = {
    getInstanceById: jest.fn().mockReturnValue({
      on: jest.fn((eventName: string, listener: (...args: any[]) => void) => {
        setTimeout(() => {
          listener(eventName, 1);
        }, 1000);
      })
    })
  };

  afterEach(() => {
    jest.clearAllMocks();
  });

  test('Successfully create EventTrigger', () => {
    expect(() => {
      new EventTrigger('instanceId', 'eventName', mockInstanceApi);
    }).not.toThrow();
  });

  test('Throw error if instanceApi is invalid', () => {
    expect(() => {
      new EventTrigger('instanceId', 'eventName', {});
    }).toThrow('InstanceApi is missing the getInstanceById function');
  });

  test('Triggered event is successfully emited', () => {
    const eventTrigger = new EventTrigger('instanceId', 'eventName', mockInstanceApi);

    const triggeredListener = jest.fn();
    eventTrigger.onTriggered(triggeredListener);
    const startSpy = jest.spyOn(eventTrigger, 'start');

    jest.runAllTimers();

    expect(mockInstanceApi.getInstanceById).toHaveBeenCalled();
    expect(mockInstanceApi.getInstanceById().on).toHaveBeenCalled();
    expect(mockInstanceApi.getInstanceById().on).toHaveBeenCalledWith('eventName', expect.anything());
    expect(startSpy).toHaveBeenCalled();
    expect(triggeredListener).toHaveBeenCalledTimes(1);
  });

  test('onTriggered listener is called with correct arguments', () => {
    const eventTrigger = new EventTrigger('instanceId', 'eventName', mockInstanceApi);

    const triggeredListener = jest.fn();
    eventTrigger.onTriggered(triggeredListener);

    jest.runAllTimers();

    expect(triggeredListener).toHaveBeenCalledWith('eventName', 1);
  });
});
