"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VariableStateMessageData = void 0;
class VariableStateMessageData {
    constructor(variableName, ownerId, typeSignature, currentValue, previousValue, lastModifiedMs) {
        this.variableName = variableName;
        this.ownerId = ownerId;
        this.typeSignature = typeSignature;
        this.currentValue = currentValue;
        this.previousValue = previousValue;
        this.lastModifiedMs = lastModifiedMs;
    }
    static create(variable) {
        return new VariableStateMessageData(variable.name, variable.ownerId, variable.typeSignature, variable.value, variable.previousValue, variable.lastModifiedMs);
    }
    static createUndefined(variableName, ownerId) {
        return new VariableStateMessageData(variableName, ownerId);
    }
}
exports.VariableStateMessageData = VariableStateMessageData;
//# sourceMappingURL=VariableStateMessageData.js.map