import { Variable, VariableType, TypeSignature } from "./Variable";
export declare class LocalVariable implements Variable {
    readonly name: string;
    readonly typeSignature: TypeSignature;
    private readonly _ownerId;
    private _currentValue;
    private _previousValue;
    private _lastModifiedMs;
    private readonly eventEmitter;
    constructor(name: string, typeSignature: TypeSignature, _ownerId: string, defaultValue?: VariableType);
    get ownerId(): string;
    get value(): VariableType;
    set value(value: VariableType);
    get previousValue(): VariableType;
    get lastModifiedMs(): number;
    onValid(listener: () => void): void;
    onInvalid(listener: () => void): void;
    onChanged(listener: (currentValue: VariableType, previousValue: VariableType) => void): void;
    onChangedInternal(listener: (variable: LocalVariable) => void): void;
    private setInternalState;
    private checkAndWarnTypeSignature;
}
