"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventParameterOperand = void 0;
class EventParameterOperand {
    constructor(eventParameterName, index) {
        this.eventParameterName = eventParameterName;
        this.index = index;
        this._value = {};
    }
    get value() {
        return this._value;
    }
    setEventParameter(...eventParameters) {
        if (eventParameters[this.index] === undefined) {
            throw new Error(`${this.eventParameterName} with index ${this.index} is not included in the EventParameters array!`);
        }
        this._value = eventParameters[this.index];
    }
}
exports.EventParameterOperand = EventParameterOperand;
//# sourceMappingURL=EventParameterOperand.js.map