"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VariableOperand = void 0;
const events_1 = require("events");
class VariableOperand extends events_1.EventEmitter {
    // TODO: Create d.ts for instanceAPI or Rewrite in typescript
    constructor(instanceApi /* eslint-enable */, instanceId, variableName) {
        super();
        this.instanceApi = instanceApi;
        this.instanceId = instanceId;
        this.variableName = variableName;
        this.variable = this.instanceApi.getInstanceById(this.instanceId).variables[this.variableName];
        this.variable.onChanged((currentValue, _previousValue) => {
            this.emit("changed", currentValue);
        });
    }
    get value() {
        return this.variable.value;
    }
    get lastModifiedMs() {
        return this.variable.lastModifiedMs;
    }
}
exports.VariableOperand = VariableOperand;
//# sourceMappingURL=VariableOperand.js.map