import { EventParameterOperand } from "./EventParameterOperand";

describe('EventParameterOperand', () => {
  test('Successfully create an EventParameterOperand', () => {
    expect(() => {
      new EventParameterOperand('test', 0);
    }).not.toThrow();
  });

  test('setEventParameter successfully changes the value to the correct eventParameter', () => {
    const eventParameterOperand = new EventParameterOperand('test', 0);

    eventParameterOperand.setEventParameter(1);

    expect(eventParameterOperand.value).toBe(1);
  });

  test('setEventParameter successfully changes the value of an already set value', () => {
    const eventParameterOperand = new EventParameterOperand('test', 0);

    eventParameterOperand.setEventParameter(1);
    eventParameterOperand.setEventParameter(2);

    expect(eventParameterOperand.value).toBe(2);
  });
});
