import { ConditionOperand, ConditionOperandType } from "./ConditionOperand";


export class EventParameterOperand implements ConditionOperand {
  private _value: ConditionOperandType = {};

  constructor(private readonly eventParameterName: string, private readonly index: number) {
  }

  get value(): ConditionOperandType {
    return this._value;
  }

  setEventParameter(...eventParameters: any[]): void {
    if (eventParameters[this.index] === undefined) {
      throw new Error(`${this.eventParameterName} with index ${this.index} is not included in the EventParameters array!`);
    }

    this._value = eventParameters[this.index] as ConditionOperandType;
  }
}
