import { EventEmitter } from "events";
import { ConditionOperand, ConditionOperandType } from "./ConditionOperand";
import { RemoteVariable } from "@lightware/variable-api";

export class VariableOperand extends EventEmitter implements ConditionOperand {
  private variable: RemoteVariable;

  // TODO: Create d.ts for instanceAPI or Rewrite in typescript
  constructor(private readonly instanceApi: /* eslint-disable */ any /* eslint-enable */,
    private readonly instanceId: string,
    private readonly variableName: string) {
    super();

    this.variable = this.instanceApi.getInstanceById(this.instanceId).variables[this.variableName];

    this.variable.onChanged((currentValue: any, _previousValue: any) => {
      this.emit("changed", currentValue);
    });
  }

  get value(): ConditionOperandType {
    return this.variable.value;
  }

  get lastModifiedMs(): number {
    return this.variable.lastModifiedMs;
  }
}
