"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepParameterType = exports.UpdateStatusStepTheme = exports.StepType = exports.ActionType = exports.ActionsDescriptor = void 0;
class ActionsDescriptor {
    constructor(code = '', type = ActionType.Code, steps = []) {
        this.code = code;
        this.type = type;
        this.steps = steps;
        if (typeof this.steps != 'object')
            this.steps = [];
        this.migrateSteps();
    }
    migrateConstParameter(value) {
        return { parameterType: StepParameterType.Constant, value };
    }
    migrateParameter(value) {
        return Array.isArray(value) ?
            value.map((v) => {
                if ('type' in v) {
                    return this.migrateConstParameter(v.value);
                }
                return this.migrateConstParameter(v);
            }) :
            this.migrateConstParameter(value);
    }
    migrateMethodParameters(s, property) {
        var _a;
        const castedStep = s.step;
        if (castedStep[property].length) {
            if ((_a = castedStep[property][0]) === null || _a === void 0 ? void 0 : _a.parameterType) {
                return s;
            }
        }
        else if (castedStep[property].parameterType) {
            return s;
        }
        return {
            ...s,
            step: {
                ...s.step,
                [property]: this.migrateParameter(castedStep[property])
            }
        };
    }
    migrateSteps() {
        this.steps = this.steps.map((s) => {
            switch (true) {
                case 'methodParameters' in s.step:
                    return this.migrateMethodParameters(s, 'methodParameters');
                case 'eventParameters' in s.step:
                    return this.migrateMethodParameters(s, 'eventParameters');
                case 'waitTimeMs' in s.step:
                    return this.migrateMethodParameters(s, 'waitTimeMs');
                case 'message' in s.step:
                    return this.migrateMethodParameters(s, 'message');
                case 'variableValue' in s.step:
                    return this.migrateMethodParameters(s, 'variableValue');
                case 'text' in s.step:
                    return this.migrateMethodParameters(s, 'text');
                case 'innerHtml' in s.step:
                    return this.migrateMethodParameters(s, 'innerHtml');
                case 'cssPropertyValue' in s.step:
                    return this.migrateMethodParameters(s, 'cssPropertyValue');
                case 'display' in s.step:
                    return s;
                case 'value' in s.step:
                    return this.migrateMethodParameters(s, 'value');
                case 'cssClassName' in s.step:
                    return this.migrateMethodParameters(s, 'cssClassName');
                case 'htmlElementValue' in s.step:
                    return this.migrateMethodParameters(s, 'htmlElementValue');
                default:
                    throw new Error('Unknown step read');
            }
        });
    }
}
exports.ActionsDescriptor = ActionsDescriptor;
var ActionType;
(function (ActionType) {
    ActionType["Wizard"] = "wizard";
    ActionType["Code"] = "code";
})(ActionType || (exports.ActionType = ActionType = {}));
var StepType;
(function (StepType) {
    StepType["MethodCall"] = "MethodCall";
    StepType["EventEmit"] = "EventEmit";
    StepType["Timeout"] = "Timeout";
    StepType["Log"] = "Log";
    StepType["SetVariable"] = "SetVariable";
})(StepType || (exports.StepType = StepType = {}));
var UpdateStatusStepTheme;
(function (UpdateStatusStepTheme) {
    UpdateStatusStepTheme["Default"] = "Default";
    UpdateStatusStepTheme["Success"] = "Success";
    UpdateStatusStepTheme["Warning"] = "Warning";
    UpdateStatusStepTheme["Error"] = "Error";
})(UpdateStatusStepTheme || (exports.UpdateStatusStepTheme = UpdateStatusStepTheme = {}));
var StepParameterType;
(function (StepParameterType) {
    StepParameterType["EventParameter"] = "eventParameter";
    StepParameterType["Constant"] = "constant";
    StepParameterType["InstanceParameter"] = "instanceParameter";
})(StepParameterType || (exports.StepParameterType = StepParameterType = {}));
//# sourceMappingURL=ActionsDescriptor.js.map