import { ConditionDescriptor, ConditionGroupDescriptor } from "./ConditionDescriptor";
import { ValueType } from "./ModuleDescriptorObject";
export declare enum TriggerType {
    Event = "event",
    VariableChanged = "variableChanged",
    VariableChangedToValue = "variableChangedToValue",
    VariableChangedFromTo = "variableChangedFromTo",
    VariableChangedIntoRange = "variableChangedIntoRange",
    Time = "time"
}
export type TriggerDescriptor = EventTriggerDescriptor | VariableChangedTriggerDescriptor | VariableChangedToValueTriggerDescriptor | VariableChangedFromToTriggerDescriptor | VariableChangedIntoRangeTriggerDescriptor | TimeTriggerDescriptor;
export type EventTriggerDescriptor = {
    type: TriggerType.Event;
    details: {
        instanceId: string;
        event: string;
    };
};
export type VariableChangedTriggerDescriptor = {
    type: TriggerType.VariableChanged;
    duration: number;
    details: {
        instanceId: string;
        variable: string;
    };
};
export type VariableChangedToValueTriggerDescriptor = {
    type: TriggerType.VariableChangedToValue;
    duration: number;
    details: {
        instanceId: string;
        variable: string;
        condition: ConditionGroupDescriptor | ConditionDescriptor;
    };
};
export type VariableChangedIntoRangeTriggerDescriptor = {
    type: TriggerType.VariableChangedIntoRange;
    duration: number;
    details: {
        instanceId: string;
        variable: string;
        condition: ConditionGroupDescriptor | ConditionDescriptor;
    };
};
export type VariableChangedFromToTriggerDescriptor = {
    type: TriggerType.VariableChangedFromTo;
    duration: number;
    details: {
        instanceId: string;
        variable: string;
        from: ValueType;
        to: ValueType;
    };
};
export type CronDescriptor = {
    seconds: string;
    minutes: string;
    hours: string;
    dayOfMonth: string;
    months: string;
    dayOfWeek: string;
};
export type TimeTriggerDescriptor = {
    type: TriggerType.Time;
    duration: 0;
    details: {
        cron: CronDescriptor;
        startDate?: string;
        endDate?: string;
    };
};
export declare function toCronString(cronStr: CronDescriptor): string;
