import { ActionsDescriptor } from "./ActionsDescriptor";
import { Parameter } from "./ModuleDescriptorObject";

export type MethodCodeData = Record<string, {
  returnType: string;
  code: string;
  description: string;
}>

export class MethodDescriptor {
  constructor(
    readonly name: string,
    readonly parameters: Parameter[],
    readonly actions: ActionsDescriptor,
    readonly description: string,
    readonly returnType: string = '',
    readonly factory: boolean = true,
    readonly orderId: number = 0
  ) {}

  public static getMethodsFromEntryCode(entryCode: string): MethodCodeData {
    const methodsStartSeparator = '/* Methods */';
    const methodsEndSeparator = '/* Methods end */';
    const codeFromStartSeparator = entryCode.substring(
      entryCode.indexOf(methodsStartSeparator) + methodsStartSeparator.length
    );
    const codeToEndSeparator = codeFromStartSeparator.substring(
      codeFromStartSeparator.indexOf('@method'),
      codeFromStartSeparator.indexOf(methodsEndSeparator)
    );

    const methods = codeToEndSeparator.split('@method ');
    const methodsData: MethodCodeData = {};

    methods.map((method: string) => {
      if (method.indexOf('@returns') == -1) return;

      const methodDescriptor = method
        .substring(0, method.indexOf('*/'))
        .replace(/\r\n/g, '\n')
        .split('\n');

      const methodName = methodDescriptor[0].toString();

      methodsData[methodName] = {
        returnType: '',
        code: '',
        description: ''
      };

      for (const line of methodDescriptor) {
        if (/@(returns|description)/.test(line)) {
          const returnMatches = line.match(/(@returns) (\{[a-zA-Z]+\})/);
          const descriptionMatches = line.match(/(@description) (\{.+\})/);

          if (returnMatches !== null) {
            methodsData[methodName].returnType = returnMatches[2].replace(/(\{|\})/g, '');
          }

          if (descriptionMatches !== null) {
            methodsData[methodName].description = decodeURIComponent(descriptionMatches[2].replace(/(\{|\})/g, ''));
          }
        }
      }

      const methodSourceCodeWithParams = method.substring(method.indexOf('async')).replace(/\r\n/g, '\n');
      const methodSourceCode = methodSourceCodeWithParams.substring(
        methodSourceCodeWithParams.indexOf('\n') + 1,
        methodSourceCodeWithParams.lastIndexOf('}')
      );

      methodsData[methodName].code = methodSourceCode;
    });

    return methodsData;
  }
}
