import { Trigger, TriggerType } from "./Trigger";

export class EventTrigger extends Trigger {
  constructor(private readonly instanceId: string, private readonly eventName: string, private readonly instanceApi: any) {
    super(TriggerType.Event, 0);

    if (typeof this.instanceApi.getInstanceById !== 'function') {
      throw new Error('InstanceApi is missing the getInstanceById function');
    }
    this.instanceApi.getInstanceById(this.instanceId).on(this.eventName, async (...args: any[]) => {
      this.start(...args);
    });
  }
}
