import { EventEmitter } from "node:events";
import { triggeredEventName } from "./common";

export enum TriggerType {
  Event = 'event',
  VariableChanged = 'variableChanged',
  VariableChangedToValue = 'variableChangedToValue',
  VariableChangedFromTo = 'variableChangedFromTo',
  VariableChangedIntoRange = 'variableChangedIntoRange',
  Time = 'time'
}

export abstract class Trigger {
  private durationTimeout: NodeJS.Timeout | undefined = undefined;

  private readonly eventEmitter: NodeJS.EventEmitter = new EventEmitter();

  constructor(private readonly type: TriggerType, private readonly durationMs: number) {
  }

  start(...triggerArgs: any[]): void {
    if (this.durationMs === 0) {
      this.eventEmitter.emit(triggeredEventName, ...triggerArgs);
    } else if (this.durationTimeout == undefined) {
      this.durationTimeout = setTimeout(() => {
        this.eventEmitter.emit(triggeredEventName, ...triggerArgs);
      }, this.durationMs);
    }
  }

  reset(): void {
    clearTimeout(this.durationTimeout);

    this.durationTimeout = undefined;
  }

  onTriggered(listener: (...triggerArgs: any[]) => void): void {
    this.eventEmitter.on(triggeredEventName, listener);
  }
}
