"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const VariableMessageType_1 = require("./VariableMessageType");
const MessageParser_1 = require("./MessageParser");
describe('MessagePareser test', () => {
    test('Parsing Changed massage', () => {
        const message = {
            messageId: 'msg1',
            instanceId: 'taurus',
            source: 'source',
            messageType: 'variable/changed',
            messageData: {
                variableName: 'var1',
                currentValue: 10,
                previousValue: 20,
                lastModifiedMs: 123,
                typeSignature: 'number'
            }
        };
        expect(() => (0, MessageParser_1.parseMessage)(JSON.stringify(message))).not.toThrow();
        const variableMessage = (0, MessageParser_1.parseMessage)(JSON.stringify(message));
        expect(variableMessage.messageType).toBe(VariableMessageType_1.VariableMessageType.Changed);
    });
    test('Parsing variable/added massage', () => {
        const message = {
            messageId: 'msg1',
            instanceId: 'taurus',
            source: 's',
            messageType: 'variable/added',
            messageData: {
                variableName: 'var1',
                currentValue: 10,
                previousValue: 20,
                lastModifiedMs: 123,
                typeSignature: 'number'
            }
        };
        expect(() => (0, MessageParser_1.parseMessage)(JSON.stringify(message))).not.toThrow();
        const variableMessage = (0, MessageParser_1.parseMessage)(JSON.stringify(message));
        expect(variableMessage.messageType).toBe(VariableMessageType_1.VariableMessageType.Added);
    });
    test('Parsing variable/getRemote massage', () => {
        const message = {
            messageId: 'msg1',
            instanceId: 'taurus',
            source: 's',
            messageType: 'variable/getRemote',
            messageData: {
                variableName: 'var1',
                currentValue: 10,
                previousValue: 20,
                lastModifiedMs: 123,
                typeSignature: 'number'
            }
        };
        expect(() => (0, MessageParser_1.parseMessage)(JSON.stringify(message))).not.toThrow();
        const variableMessage = (0, MessageParser_1.parseMessage)(JSON.stringify(message));
        expect(variableMessage.messageType).toBe(VariableMessageType_1.VariableMessageType.GetRemote);
    });
    test('Parsing variable/getRemoteResponse massage', () => {
        const message = {
            messageId: 'msg1',
            instanceId: 'taurus',
            source: 's',
            messageType: 'variable/getRemoteResponse',
            messageData: {
                variableName: 'var1',
                currentValue: 10,
                previousValue: 20,
                lastModifiedMs: 123,
                typeSignature: 'number'
            }
        };
        expect(() => (0, MessageParser_1.parseMessage)(JSON.stringify(message))).not.toThrow();
        const variableMessage = (0, MessageParser_1.parseMessage)(JSON.stringify(message));
        expect(variableMessage.messageType).toBe(VariableMessageType_1.VariableMessageType.GetRemoteResponse);
    });
    test('Parsing Wrong message type', () => {
        const message = {
            messageId: 'msg1',
            instanceId: 'taurus',
            source: 'source',
            messageType: 'wrongType',
            messageData: {
                variableName: 'var1',
                ownerId: 'taurus',
                currentValue: 10,
                previousValue: 20,
                lastModifiedMs: 123,
                typeSignature: 'number'
            }
        };
        expect((0, MessageParser_1.parseMessage)(JSON.stringify(message))).toBeNull();
    });
});
//# sourceMappingURL=MessageParser.test.js.map