export type VariableType = number | string | boolean | object | undefined;
export declare enum TypeSignature {
    String = "string",
    Number = "number",
    Boolean = "boolean",
    Object = "object",
    Undefined = "undefined"
}
export declare enum StateChange {
    None = 0,
    ToValid = 1,
    ToInvalid = 2
}
export interface Variable {
    get ownerId(): string;
    get value(): VariableType;
    set value(value: VariableType);
    get previousValue(): VariableType;
    get lastModifiedMs(): number;
    onValid(listener: () => void): void;
    onInvalid(listener: () => void): void;
    onChanged(listener: (currentValue: VariableType, previousValue: VariableType) => void): void;
}
