var params = {};

let paramHandler = {
  checkPropertyState: function (target, prop) {
    if (target[prop] === undefined || target[prop] === null || target[prop] === NaN) {
      target[prop] = {};
    }
  },

  get: function (target, prop, receiver) {
    this.checkPropertyState(target, prop);
    return target[prop];
  },

  set: function (target, prop, value) {
    throw new Error('parameters are read only!');
  }
};

if(typeof(window) != "undefined" && typeof(document) != "undefined"){
  params = new Proxy(paramsObject, paramHandler);
}
else{
  let instanceDir = process.argv[2];
  let paramsObject = require(`${instanceDir}/parameters.json`);

  module.exports = new Proxy(paramsObject, paramHandler);
}
